<?php

namespace App\Core;

class Response
{
    public static function json($data, int $status = 200): string
    {
        http_response_code($status);
        return json_encode($data, JSON_UNESCAPED_UNICODE);
    }
    
    public static function success($data, string $message = null): string
    {
        $response = ['success' => true];
        
        if ($message) {
            $response['message'] = $message;
        }
        
        if ($data) {
            $response['data'] = $data;
        }
        
        return self::json($response);
    }
    
    public static function error(string $message, int $status = 400): string
    {
        return self::json(['error' => $message], $status);
    }
    
    public static function notFound(string $message = 'Not found'): string
    {
        return self::error($message, 404);
    }
    
    public static function unauthorized(string $message = 'Unauthorized'): string
    {
        return self::error($message, 401);
    }
    
    public static function forbidden(string $message = 'Forbidden'): string
    {
        return self::error($message, 403);
    }
}
