<?php

namespace App\Core;

class Request
{
    public static function getBody(): array
    {
        $body = file_get_contents('php://input');
        return json_decode($body, true) ?? [];
    }
    
    public static function get(string $key, $default = null)
    {
        return $_GET[$key] ?? $default;
    }
    
    public static function post(string $key, $default = null)
    {
        return $_POST[$key] ?? $default;
    }
    
    public static function json(): array
    {
        return self::getBody();
    }
    
    public static function validate(array $data, array $rules): array
    {
        $errors = [];
        
        foreach ($rules as $field => $rule) {
            $value = $data[$field] ?? null;
            
            if (strpos($rule, 'required') !== false && empty($value)) {
                $errors[$field] = "$field é obrigatório";
            }
            
            if (strpos($rule, 'email') !== false && !filter_var($value, FILTER_VALIDATE_EMAIL)) {
                $errors[$field] = "$field deve ser um email válido";
            }
            
            if (preg_match('/min:(\d+)/', $rule, $matches)) {
                $min = (int)$matches[1];
                if (strlen($value) < $min) {
                    $errors[$field] = "$field deve ter no mínimo $min caracteres";
                }
            }
        }
        
        return $errors;
    }
}
