<?php

namespace App\Controllers;

use App\Core\Database;
use App\Core\Auth;
use App\Core\Request;
use App\Core\Response;

class RestaurantController
{
    public function index(): string
    {
        $search = Request::get('search', '');
        $category = Request::get('category', '');
        
        $sql = 'SELECT * FROM restaurants WHERE status = ?';
        $params = ['active'];
        
        if ($category) {
            $sql .= ' AND category = ?';
            $params[] = $category;
        }
        
        if ($search) {
            $sql .= ' AND (name LIKE ? OR description LIKE ?)';
            $params[] = "%$search%";
            $params[] = "%$search%";
        }
        
        $sql .= ' ORDER BY rating DESC, name ASC';
        
        $restaurants = Database::query($sql, $params);
        
        return Response::json($restaurants);
    }
    
    public function show(string $id): string
    {
        $restaurants = Database::query('SELECT * FROM restaurants WHERE id = ?', [$id]);
        
        if (empty($restaurants)) {
            return Response::notFound('Restaurante não encontrado');
        }
        
        $restaurant = $restaurants[0];
        
        // Get categories
        $restaurant['categories'] = Database::query(
            'SELECT * FROM categories WHERE restaurant_id = ? AND is_active = 1 ORDER BY display_order',
            [$id]
        );
        
        // Get products
        $restaurant['products'] = Database::query(
            'SELECT * FROM products WHERE restaurant_id = ? AND is_available = 1',
            [$id]
        );
        
        return Response::json($restaurant);
    }
    
    public function create(): string
    {
        $user = Auth::requireAuth();
        $data = Request::json();
        
        $name = $data['name'] ?? '';
        $description = $data['description'] ?? '';
        $category = $data['category'] ?? '';
        $phone = $data['phone'] ?? '';
        $email = $data['email'] ?? '';
        $address = $data['address'] ?? '';
        
        if (empty($name)) {
            return Response::error('Nome é obrigatório');
        }
        
        $slug = strtolower(preg_replace('/[^a-z0-9]+/i', '-', $name));
        
        Database::execute(
            'INSERT INTO restaurants (owner_id, name, slug, description, category, phone, email, address, status) 
             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)',
            [$user['userId'], $name, $slug, $description, $category, $phone, $email, $address, 'pending']
        );
        
        $restaurantId = Database::lastInsertId();
        
        $restaurants = Database::query('SELECT * FROM restaurants WHERE id = ?', [$restaurantId]);
        
        return Response::json($restaurants[0]);
    }
}
