<?php

namespace App\Controllers;

use App\Core\Database;
use App\Core\Auth;
use App\Core\Response;

class AdminController
{
    public function dashboard(): string
    {
        Auth::requireRole('admin');
        
        $stats = Database::query("
            SELECT 
                (SELECT COUNT(*) FROM restaurants WHERE status = 'active') as active_restaurants,
                (SELECT COUNT(*) FROM users WHERE role = 'customer') as total_customers,
                (SELECT COUNT(*) FROM orders WHERE created_at > DATE_SUB(NOW(), INTERVAL 30 DAY)) as orders_last_30_days,
                (SELECT SUM(total) FROM orders WHERE created_at > DATE_SUB(NOW(), INTERVAL 30 DAY)) as revenue_last_30_days
        ");
        
        return Response::json($stats[0]);
    }
    
    public function pendingRestaurants(): string
    {
        Auth::requireRole('admin');
        
        $restaurants = Database::query(
            'SELECT * FROM restaurants WHERE status = ? ORDER BY created_at DESC',
            ['pending']
        );
        
        return Response::json($restaurants);
    }
    
    public function approveRestaurant(string $id): string
    {
        Auth::requireRole('admin');
        
        Database::execute('UPDATE restaurants SET status = ? WHERE id = ?', ['active', $id]);
        
        $restaurants = Database::query('SELECT * FROM restaurants WHERE id = ?', [$id]);
        
        return Response::json($restaurants[0]);
    }
}
