<?php

// PHP Puro - Sem bibliotecas externas
require_once __DIR__ . '/../includes/autoload.php';

use App\Core\Router;
use App\Controllers\AuthController;
use App\Controllers\RestaurantController;
use App\Controllers\ProductController;
use App\Controllers\OrderController;
use App\Controllers\AdminController;

// Headers
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Error handling
error_reporting(E_ALL);
ini_set('display_errors', 0);

set_error_handler(function($errno, $errstr, $errfile, $errline) {
    http_response_code(500);
    echo json_encode(['error' => 'Internal server error']);
    exit;
});

// Router
$router = new Router();

// Auth routes
$router->post('/api/auth/register', [AuthController::class, 'register']);
$router->post('/api/auth/login', [AuthController::class, 'login']);
$router->get('/api/auth/me', [AuthController::class, 'me']);

// Restaurant routes
$router->get('/api/restaurants', [RestaurantController::class, 'index']);
$router->get('/api/restaurants/{id}', [RestaurantController::class, 'show']);
$router->post('/api/restaurants', [RestaurantController::class, 'create']);

// Product routes
$router->get('/api/products/restaurant/{restaurantId}', [ProductController::class, 'byRestaurant']);
$router->post('/api/products', [ProductController::class, 'create']);
$router->put('/api/products/{id}', [ProductController::class, 'update']);

// Order routes
$router->post('/api/orders', [OrderController::class, 'create']);
$router->get('/api/orders/my-orders', [OrderController::class, 'myOrders']);
$router->put('/api/orders/{id}/status', [OrderController::class, 'updateStatus']);

// Admin routes
$router->get('/api/admin/dashboard', [AdminController::class, 'dashboard']);
$router->get('/api/admin/restaurants/pending', [AdminController::class, 'pendingRestaurants']);
$router->put('/api/admin/restaurants/{id}/approve', [AdminController::class, 'approveRestaurant']);

// Health check
$router->get('/api/health', function() {
    return json_encode(['status' => 'ok', 'timestamp' => date('c')]);
});

$router->dispatch();
