// Get restaurant ID from URL
const urlParams = new URLSearchParams(window.location.search);
const restaurantId = urlParams.get('id');

if (!restaurantId) {
    window.location.href = '/';
}

// Load restaurant details
async function loadRestaurant() {
    try {
        const restaurant = await apiRequest(`/restaurants/${restaurantId}`);
        
        // Render header
        const header = document.getElementById('restaurant-header');
        header.innerHTML = `
            <div class="banner">
                ${restaurant.banner_url 
                    ? `<img src="${restaurant.banner_url}" alt="${restaurant.name}">` 
                    : '<div class="no-image">Sem imagem</div>'}
            </div>
            <div class="container">
                <div class="restaurant-details">
                    <h1>${restaurant.name}</h1>
                    <p class="description">${restaurant.description || ''}</p>
                    <div class="meta">
                        <span>⭐ ${restaurant.rating || '5.0'}</span>
                        <span>🕐 ${restaurant.delivery_time_min}-${restaurant.delivery_time_max} min</span>
                        <span>Taxa: ${formatCurrency(restaurant.delivery_fee || 0)}</span>
                    </div>
                </div>
            </div>
        `;
        
        // Render menu
        const menuDiv = document.getElementById('menu');
        
        if (!restaurant.products || restaurant.products.length === 0) {
            menuDiv.innerHTML = '<p class="no-results">Nenhum produto disponível</p>';
            return;
        }
        
        // Group products by category
        const categories = restaurant.categories || [];
        
        menuDiv.innerHTML = categories.map(category => {
            const categoryProducts = restaurant.products.filter(p => p.category_id === category.id);
            
            if (categoryProducts.length === 0) return '';
            
            return `
                <div class="category-section">
                    <h2>${category.name}</h2>
                    <div class="products-grid">
                        ${categoryProducts.map(product => `
                            <div class="product-card">
                                <div class="product-info">
                                    <h3>${product.name}</h3>
                                    <p class="product-description">${product.description || ''}</p>
                                    <p class="product-price">${formatCurrency(product.price)}</p>
                                </div>
                                ${product.image_url ? `<img src="${product.image_url}" alt="${product.name}" class="product-image">` : ''}
                                <button class="btn btn-primary btn-add" onclick="addToCart(${product.id}, '${product.name}', ${product.price}, ${restaurantId})">
                                    Adicionar
                                </button>
                            </div>
                        `).join('')}
                    </div>
                </div>
            `;
        }).join('');
        
    } catch (error) {
        document.getElementById('restaurant-header').innerHTML = `<p class="error">Erro: ${error.message}</p>`;
    }
}

// Add to cart
function addToCart(id, name, price, restaurant_id) {
    cart.addItem({ id, name, price, restaurant_id });
    alert('Produto adicionado ao carrinho!');
}

// Load restaurant
loadRestaurant();
