async function loadOrders() {
    const ordersList = document.getElementById('orders-list');
    
    try {
        const orders = await apiRequest('/orders/my-orders');
        
        if (orders.length === 0) {
            ordersList.innerHTML = `
                <div class="empty-orders">
                    <p>Você ainda não fez nenhum pedido</p>
                    <a href="/" class="btn btn-primary">Ver restaurantes</a>
                </div>
            `;
            return;
        }
        
        const statusColors = {
            pending: 'status-pending',
            confirmed: 'status-confirmed',
            preparing: 'status-preparing',
            ready: 'status-ready',
            delivering: 'status-delivering',
            delivered: 'status-delivered',
            cancelled: 'status-cancelled'
        };
        
        const statusLabels = {
            pending: 'Pendente',
            confirmed: 'Confirmado',
            preparing: 'Preparando',
            ready: 'Pronto',
            delivering: 'Saiu para entrega',
            delivered: 'Entregue',
            cancelled: 'Cancelado'
        };
        
        ordersList.innerHTML = orders.map(order => `
            <div class="order-card">
                <div class="order-header">
                    <div class="order-info">
                        <h3>${order.restaurant_name}</h3>
                        <p>Pedido #${order.order_number}</p>
                        <p>${new Date(order.created_at).toLocaleString('pt-BR')}</p>
                    </div>
                    
                    <span class="order-status ${statusColors[order.status]}">
                        ${statusLabels[order.status]}
                    </span>
                </div>
                
                <div class="order-footer">
                    <div class="status-text">
                        ${order.status === 'delivered' ? '✅ Entregue' : '🕐 Em andamento'}
                    </div>
                    
                    <span class="order-total">${formatCurrency(order.total)}</span>
                </div>
            </div>
        `).join('');
        
    } catch (error) {
        ordersList.innerHTML = `<p class="error">Erro ao carregar pedidos: ${error.message}</p>`;
    }
}

loadOrders();
