// Load restaurants
async function loadRestaurants(search = '') {
    const grid = document.getElementById('restaurants-grid');
    
    try {
        const restaurants = await apiRequest(`/restaurants?search=${search}`);
        
        if (restaurants.length === 0) {
            grid.innerHTML = '<p class="no-results">Nenhum restaurante encontrado</p>';
            return;
        }
        
        grid.innerHTML = restaurants.map(restaurant => `
            <div class="restaurant-card" onclick="window.location.href='/client/restaurant.html?id=${restaurant.id}'">
                <div class="restaurant-banner">
                    ${restaurant.banner_url 
                        ? `<img src="${restaurant.banner_url}" alt="${restaurant.name}">` 
                        : '<div class="no-image">Sem imagem</div>'}
                </div>
                <div class="restaurant-info">
                    <h3>${restaurant.name}</h3>
                    <p class="category">${restaurant.category || 'Diversos'}</p>
                    <div class="restaurant-meta">
                        <span>⭐ ${restaurant.rating || '5.0'}</span>
                        <span>🕐 ${restaurant.delivery_time_min}-${restaurant.delivery_time_max} min</span>
                        <span>${formatCurrency(restaurant.delivery_fee || 0)}</span>
                    </div>
                </div>
            </div>
        `).join('');
        
    } catch (error) {
        grid.innerHTML = `<p class="error">Erro ao carregar restaurantes: ${error.message}</p>`;
    }
}

// Search functionality
const searchInput = document.getElementById('search');
let searchTimeout;

searchInput.addEventListener('input', (e) => {
    clearTimeout(searchTimeout);
    searchTimeout = setTimeout(() => {
        loadRestaurants(e.target.value);
    }, 500);
});

// Initial load
loadRestaurants();
