function renderCart() {
    const content = document.getElementById('cart-content');
    
    if (cart.items.length === 0) {
        content.innerHTML = `
            <div class="empty-cart">
                <p>Seu carrinho está vazio</p>
                <a href="/" class="btn btn-primary">Ver restaurantes</a>
            </div>
        `;
        return;
    }
    
    content.innerHTML = `
        <div class="cart-items">
            <h2>Itens do Pedido</h2>
            ${cart.items.map(item => `
                <div class="cart-item">
                    <div class="item-info">
                        <h3>${item.name}</h3>
                        <p class="item-price">${formatCurrency(item.price)}</p>
                    </div>
                    <div class="item-controls">
                        <button onclick="updateQuantity(${item.id}, ${item.quantity - 1})">-</button>
                        <span>${item.quantity}</span>
                        <button onclick="updateQuantity(${item.id}, ${item.quantity + 1})">+</button>
                    </div>
                    <div class="item-total">
                        ${formatCurrency(item.price * item.quantity)}
                    </div>
                    <button class="btn-remove" onclick="removeItem(${item.id})">🗑️</button>
                </div>
            `).join('')}
            
            <div class="cart-total">
                <span>Total</span>
                <span class="total-value">${formatCurrency(cart.getTotal())}</span>
            </div>
        </div>
        
        <div class="payment-section">
            <h2>Forma de Pagamento</h2>
            <div class="payment-methods">
                <label>
                    <input type="radio" name="payment" value="credit_card" checked>
                    Cartão de Crédito
                </label>
                <label>
                    <input type="radio" name="payment" value="debit_card">
                    Cartão de Débito
                </label>
                <label>
                    <input type="radio" name="payment" value="pix">
                    PIX
                </label>
                <label>
                    <input type="radio" name="payment" value="cash">
                    Dinheiro
                </label>
            </div>
        </div>
        
        <button class="btn btn-primary btn-checkout" onclick="checkout()">
            Finalizar Pedido
        </button>
    `;
}

function updateQuantity(productId, quantity) {
    cart.updateQuantity(productId, quantity);
    renderCart();
}

function removeItem(productId) {
    if (confirm('Remover item do carrinho?')) {
        cart.removeItem(productId);
        renderCart();
    }
}

async function checkout() {
    const paymentMethod = document.querySelector('input[name="payment"]:checked').value;
    
    if (cart.items.length === 0) {
        alert('Carrinho vazio');
        return;
    }
    
    const restaurantId = cart.items[0].restaurant_id;
    
    const orderData = {
        restaurant_id: restaurantId,
        items: cart.items.map(item => ({
            product_id: item.id,
            quantity: item.quantity
        })),
        delivery_address_id: 1, // TODO: Get from user
        payment_method: paymentMethod
    };
    
    try {
        await apiRequest('/orders', {
            method: 'POST',
            body: JSON.stringify(orderData)
        });
        
        cart.clear();
        alert('Pedido realizado com sucesso!');
        window.location.href = '/client/orders.html';
    } catch (error) {
        alert('Erro ao finalizar pedido: ' + error.message);
    }
}

renderCart();
