# 🚀 Guia de Instalação - Delivery SaaS PHP Puro + MySQL

## ✨ 100% PHP Puro - Sem Composer, Sem Bibliotecas Externas!

## Pré-requisitos

- PHP 8.1+ (apenas extensões nativas: PDO, JSON, mbstring)
- MySQL 8.0+
- Servidor web (Apache/Nginx) ou PHP built-in server

## Instalação Rápida com Docker

```bash
# 1. Subir MySQL e phpMyAdmin
docker-compose up -d

# 2. Aguardar MySQL iniciar (30 segundos)
# O schema será importado automaticamente

# 3. Configurar ambiente
cp config/config.example.php config/config.php

# 4. Iniciar servidor PHP (sem dependências!)
php -S localhost:8000 -t public
```

## Instalação Manual

### 1. Banco de Dados MySQL

```bash
# Criar banco
mysql -u root -p -e "CREATE DATABASE delivery_saas CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"

# Importar schema
mysql -u root -p delivery_saas < database/schema.sql
```

### 2. Configuração

```bash
# Copiar arquivo de configuração
cp config/config.example.php config/config.php

# Editar credenciais do banco
# Windows: notepad config/config.php
# Linux/Mac: nano config/config.php
```

### 3. Iniciar Servidor

```bash
# Servidor embutido PHP (desenvolvimento)
php -S localhost:8000 -t public

# Ou configurar Apache/Nginx apontando para /public
```

## URLs de Acesso

- **Cliente**: http://localhost:8000/client
- **API**: http://localhost:8000/api
- **phpMyAdmin**: http://localhost:8080 (se usar Docker)

## Estrutura do Projeto (PHP Puro)

```
delivery-saas-php/
├── config/
│   └── config.php          # Configurações
├── database/
│   └── schema.sql          # Schema MySQL
├── includes/
│   └── autoload.php        # Autoloader PSR-4 nativo
├── public/
│   ├── index.php          # Entry point API
│   ├── .htaccess          # Rewrite rules
│   └── client/            # Frontend HTML/CSS/JS
├── src/
│   ├── Controllers/       # Controllers
│   │   ├── AuthController.php
│   │   ├── RestaurantController.php
│   │   ├── ProductController.php
│   │   ├── OrderController.php
│   │   └── AdminController.php
│   └── Core/             # Classes core
│       ├── Router.php    # Router customizado
│       ├── Database.php  # PDO wrapper
│       ├── Auth.php      # JWT nativo
│       ├── Request.php   # Request helper
│       └── Response.php  # Response helper
└── README.md
```

## Características Técnicas

### ✅ Sem Dependências Externas
- **Autoloader PSR-4**: Implementado manualmente
- **Router**: Sistema de rotas customizado
- **JWT**: Implementação nativa de JSON Web Tokens
- **Validação**: Sistema de validação próprio
- **PDO**: Apenas extensão nativa do PHP

### ✅ Funcionalidades Implementadas
- Sistema de autenticação JWT
- CRUD completo de restaurantes
- Gerenciamento de produtos
- Sistema de pedidos
- Painel administrativo
- API REST completa

## Dados de Teste

### Admin padrão (já criado no schema):
- **Email**: admin@delivery.com
- **Senha**: admin123

### Criar restaurante via cURL:

```bash
curl -X POST http://localhost:8000/api/auth/register \
  -H "Content-Type: application/json" \
  -d "{\"email\":\"restaurante@example.com\",\"password\":\"rest123\",\"name\":\"Restaurante Teste\",\"phone\":\"11999999999\",\"role\":\"restaurant_owner\"}"
```

### Criar cliente:

```bash
curl -X POST http://localhost:8000/api/auth/register \
  -H "Content-Type: application/json" \
  -d "{\"email\":\"cliente@example.com\",\"password\":\"cliente123\",\"name\":\"Cliente Teste\",\"phone\":\"11988888888\"}"
```

### Fazer login:

```bash
curl -X POST http://localhost:8000/api/auth/login \
  -H "Content-Type: application/json" \
  -d "{\"email\":\"admin@delivery.com\",\"password\":\"admin123\"}"
```

## Endpoints da API

### Autenticação
- `POST /api/auth/register` - Registrar usuário
- `POST /api/auth/login` - Login
- `GET /api/auth/me` - Dados do usuário logado

### Restaurantes
- `GET /api/restaurants` - Listar restaurantes
- `GET /api/restaurants/{id}` - Detalhes do restaurante
- `POST /api/restaurants` - Criar restaurante

### Produtos
- `GET /api/products/restaurant/{id}` - Produtos do restaurante
- `POST /api/products` - Criar produto
- `PUT /api/products/{id}` - Atualizar produto

### Pedidos
- `POST /api/orders` - Criar pedido
- `GET /api/orders/my-orders` - Meus pedidos
- `PUT /api/orders/{id}/status` - Atualizar status

### Admin
- `GET /api/admin/dashboard` - Estatísticas
- `GET /api/admin/restaurants/pending` - Restaurantes pendentes
- `PUT /api/admin/restaurants/{id}/approve` - Aprovar restaurante

## Configuração Apache

Se usar Apache, crie um VirtualHost:

```apache
<VirtualHost *:80>
    ServerName delivery.local
    DocumentRoot /caminho/para/delivery-saas-php/public
    
    <Directory /caminho/para/delivery-saas-php/public>
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

## Configuração Nginx

```nginx
server {
    listen 80;
    server_name delivery.local;
    root /caminho/para/delivery-saas-php/public;
    index index.php;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }
}
```

## Troubleshooting

### Erro de conexão MySQL:
```bash
# Verificar se MySQL está rodando
docker ps

# Ver logs
docker-compose logs mysql
```

### Erro 404 nas rotas:
- Certifique-se de que o `.htaccess` está ativo
- Verifique se `mod_rewrite` está habilitado no Apache
- Use o servidor PHP built-in para testes: `php -S localhost:8000 -t public`

### Erro de permissão:
```bash
# Linux/Mac
chmod -R 755 public/
chmod -R 777 public/uploads/

# Windows: não necessário
```

### Erro de autoload:
- Verifique se o arquivo `includes/autoload.php` existe
- Certifique-se de que está usando PHP 8.1+

## Vantagens do PHP Puro

✅ **Zero dependências** - Não precisa de Composer  
✅ **Mais rápido** - Sem overhead de bibliotecas  
✅ **Mais leve** - Apenas ~50KB de código  
✅ **Fácil deploy** - Apenas copiar arquivos  
✅ **Compatível** - Funciona em qualquer servidor PHP  

## Próximos Passos

1. Personalize o tema em `public/client/css/style.css`
2. Configure upload de imagens
3. Adicione integração de pagamento
4. Configure email SMTP
5. Implemente cache com Redis (opcional)
