# 🍔 Delivery SaaS Platform - PHP Puro + MySQL

## ✨ 100% PHP Puro - Sem Composer, Sem Bibliotecas Externas!

Plataforma completa de delivery multi-tenant estilo iFood desenvolvida em **PHP puro** com **MySQL**.

## 🚀 Funcionalidades

### Para Clientes
- ✅ Busca de restaurantes por localização
- ✅ Catálogo de produtos com filtros
- ✅ Carrinho de compras (localStorage)
- ✅ Sistema de pedidos
- ✅ Histórico de pedidos
- ✅ Avaliações e reviews

### Para Restaurantes
- ✅ Painel de gestão completo
- ✅ Gerenciamento de cardápio
- ✅ Controle de pedidos
- ✅ Relatórios e analytics
- ✅ Gestão de horários

### Para Admin (Plataforma)
- ✅ Gestão de restaurantes
- ✅ Aprovação de cadastros
- ✅ Dashboard analytics
- ✅ Gestão de usuários

## 🏗️ Arquitetura

- **Backend**: PHP 8.1+ Puro (POO, MVC)
- **Database**: MySQL 8.0+
- **Frontend**: HTML5 + CSS3 + JavaScript Vanilla
- **Autenticação**: JWT implementado nativamente
- **Router**: Sistema de rotas customizado
- **Autoloader**: PSR-4 nativo

## 📦 Instalação Rápida

```bash
# 1. Subir banco de dados
docker-compose up -d

# 2. Configurar
cp config/config.example.php config/config.php

# 3. Iniciar (SEM COMPOSER!)
php -S localhost:8000 -t public
```

Acesse: http://localhost:8000/client

## 📱 Acesso

- **Cliente**: http://localhost:8000/client
- **API**: http://localhost:8000/api
- **phpMyAdmin**: http://localhost:8080

## 🔧 Requisitos

- PHP 8.1+ (apenas extensões nativas)
- MySQL 8.0+
- Nenhuma biblioteca externa!

## 📚 Documentação

Veja [SETUP.md](SETUP.md) para instruções detalhadas de instalação e configuração.

## 🎯 Características Técnicas

### Implementações Nativas

- **JWT**: Sistema de autenticação JWT implementado do zero
- **Router**: Sistema de rotas com suporte a parâmetros dinâmicos
- **Autoloader**: PSR-4 autoloader customizado
- **Validação**: Sistema de validação de dados
- **Response/Request**: Helpers para HTTP
- **Database**: Wrapper PDO com prepared statements

### Segurança

- ✅ Prepared statements (SQL Injection)
- ✅ Password hashing (bcrypt)
- ✅ JWT com HMAC SHA256
- ✅ CORS configurado
- ✅ Input validation

## 📂 Estrutura

```
delivery-saas-php/
├── config/              # Configurações
├── database/            # Schema SQL
├── includes/            # Autoloader
├── public/              # Arquivos públicos
│   ├── index.php       # Entry point
│   └── client/         # Frontend
├── src/
│   ├── Controllers/    # Controllers
│   └── Core/          # Classes core
└── README.md
```

## 🔌 API Endpoints

- `POST /api/auth/register` - Registrar
- `POST /api/auth/login` - Login
- `GET /api/restaurants` - Listar restaurantes
- `GET /api/restaurants/{id}` - Detalhes
- `POST /api/orders` - Criar pedido
- `GET /api/orders/my-orders` - Meus pedidos

## 🎨 Frontend

Interface moderna e responsiva desenvolvida com:
- HTML5 semântico
- CSS3 (Flexbox, Grid)
- JavaScript Vanilla (ES6+)
- LocalStorage para carrinho

## 🚀 Deploy

Basta copiar os arquivos para o servidor:

```bash
# Upload via FTP/SFTP
scp -r * user@server:/var/www/html/

# Configurar permissões
chmod -R 755 public/
```

## 📝 Licença

MIT License - Livre para uso comercial e pessoal.

## 🤝 Contribuindo

Contribuições são bem-vindas! Este projeto demonstra que é possível criar aplicações robustas com PHP puro, sem frameworks pesados.

---

**Desenvolvido com PHP Puro** 🐘
